// NetBroadcasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBroadcaster.h"
#include "NetBroadcasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = nVideoWidth;
	
	pNetBroadcasterDlg->m_nVideoHeight = nVideoHeight;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = dVideoFrameRate;
	
	pNetBroadcasterDlg->m_nAudioChannels = nAudioChannels; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

	pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 0 ] );

	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 0 ] >= 0x00000003 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 1 ] );

	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 1 ] >= 0x00000003 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 1 ] );

    return QCAP_RT_OK;
}

// HARDWARE VIDEO ENCODER CALLBACK FUNCTION
//
QRETURN on_hardware_main_encoder_callback( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);
	
	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 0 ] );

	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 0 ] == 0x00000001 ) {

		if( bIsKeyFrame ) {

			pNetBroadcasterDlg->m_nNetworkServerStates[ 0 ] = 0x00000003;
		}
	}
	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 0 ] >= 0x00000003 ) {

		QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 0 ] );

	return QCAP_RT_OK;
}

QRETURN on_hardware_sub_encoder_callback( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);
	
	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 1 ] );

	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 1 ] == 0x00000001 ) {

		if( bIsKeyFrame ) {

			pNetBroadcasterDlg->m_nNetworkServerStates[ 1 ] = 0x00000003;
		}
	}
	if( pNetBroadcasterDlg->m_nNetworkServerStates[ 1 ] >= 0x00000003 ) {

		QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections[ 1 ] );

	return QCAP_RT_OK;
}

extern CNetBroadcasterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg dialog

CNetBroadcasterDlg::CNetBroadcasterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBroadcasterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetBroadcasterDlg)
	m_nPort_RTMPOverHTTP = 0;
	m_nPort_RTMP = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetBroadcasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBroadcasterDlg)
	DDX_Control(pDX, IDC_STATIC_FORMAT, m_statFormat);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW, m_statDisplayWindow);
	DDX_Text(pDX, IDC_EDIT_HTTP, m_nPort_RTMPOverHTTP);
	DDV_MinMaxDWord(pDX, m_nPort_RTMPOverHTTP, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP, m_nPort_RTMP);
	DDV_MinMaxDWord(pDX, m_nPort_RTMP, 0, 65535);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetBroadcasterDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBroadcasterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg message handlers

BOOL CNetBroadcasterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_pDevice = NULL;

	m_hNetworkServer = NULL;

	m_nNetworkServerStates[ 0 ] = 0x00000000;

	m_nNetworkServerStates[ 1 ] = 0x00000000;

	m_nVideoWidth = 0;
	
	m_nVideoHeight = 0;
	
	m_bVideoIsInterleaved = FALSE;
	
	m_dVideoFrameRate = 0.0;
	
	m_nAudioChannels = 0; 
	
	m_nAudioBitsPerSample = 0;
	
	m_nAudioSampleFrequency = 0;

	m_nPort_RTMP = theApp.GetProfileInt( "DEFAULT", "PORT.RTMP", 1935 );

	m_nPort_RTMPOverHTTP = theApp.GetProfileInt( "DEFAULT", "PORT.HTTP", 0 );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	UpdateData( FALSE );

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "FH8735 PCI", 0, m_statDisplayWindow.m_hWnd, &m_pDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice, 0, on_hardware_main_encoder_callback, this );

	QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice, 1, on_hardware_sub_encoder_callback, this );

	QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_SET_AUDIO_VOLUME( m_pDevice, 0 );
	
	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_pDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_pDevice, 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 3 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2, 0, 0);

	QCAP_RUN( m_pDevice );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetBroadcasterDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE DEVICE RESOURCE
	//
	OnButtonStop();

	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE MEMBER VARIABLES
	//
	UpdateData( TRUE );

	theApp.WriteProfileInt( "DEFAULT", "PORT.RTMP", m_nPort_RTMP );

	theApp.WriteProfileInt( "DEFAULT", "PORT.HTTP", m_nPort_RTMPOverHTTP );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CNetBroadcasterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBroadcasterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetBroadcasterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetBroadcasterDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CNetBroadcasterDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CNetBroadcasterDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	OnButtonStop();

	if( m_nVideoWidth == 0 ) { return ; }

	if( m_nVideoHeight == 0 ) { return ; }

	double fps = m_dVideoFrameRate;

	if( m_bVideoIsInterleaved ) {

		fps /= 2;
	}
	QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 2 /*2 CHANNELS*/, &m_hNetworkServer, NULL, NULL, m_nPort_RTMP, m_nPort_RTMPOverHTTP );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth / 1, m_nVideoHeight / 1, fps, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 16, 9, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth / 2, m_nVideoHeight / 2, fps, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 16, 9, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	m_nNetworkServerStates[ 0 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 1 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CNetBroadcasterDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	m_nNetworkServerStates[ 0 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 1 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	if ( m_hNetworkServer != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

		m_hNetworkServer = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}

void CNetBroadcasterDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x000000000 ) {

		KillTimer( 0x00000000 );

		if( m_nVideoWidth == 0 ||

			m_nVideoHeight == 0 ) {

			m_statFormat.SetWindowText( "INFO: ..." );
		}
		else {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "INFO: %d x %d%c @ %2.3f, %d x %d x %d", m_nVideoWidth, m_nVideoHeight, m_bVideoIsInterleaved ? 'i' : 'p', m_dVideoFrameRate, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

			m_statFormat.SetWindowText( psz );
		}
	}
	CDialog::OnTimer(nIDEvent);
}